unit scaler1;

interface

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, Grids, DBGrids, Gridscal, Dbigrid, DBTables, StdCtrls, Scaler, PrintSel,
  Buttons, ExtCtrls, DBCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    grdFishes: TDBIGrid;
    Table1NAME: TStringField;
    Table1SIZE: TSmallintField;
    Table1WEIGHT: TSmallintField;
    Table1AREA: TStringField;
    Table1BMP: TBlobField;
    Scaler: TScaler;
    prtSelection: TPrinterDefinition;
    Bevel1: TBevel;
    cmbPaperSize: TComboBox;
    cmbPaperBin: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    btnPrintForm: TBitBtn;
    Label4: TLabel;
    lblWidth: TLabel;
    lblHeight: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit1: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Edit2: TEdit;
    Label10: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Label11: TLabel;
    Panel1: TPanel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    btnExit: TBitBtn;
    chkLandscape: TCheckBox;
    DBImage1: TDBImage;
    Image1: TImage;
    Image2: TImage;
    procedure btnPrintFormClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure cmbPaperSizeChange(Sender: TObject);
    procedure cmbPaperBinChange(Sender: TObject);
    procedure chkLandscapeClick(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.cmbPaperSizeChange(Sender: TObject);
begin
  prtSelection.PrinterSettings.PaperSize:=cmbPaperSize.Text;
end;

procedure TForm1.cmbPaperBinChange(Sender: TObject);
begin
  prtSelection.PrinterSettings.BinSource:=cmbPaperBin.Text;
end;

procedure TForm1.btnPrintFormClick(Sender: TObject);
begin
  btnPrintForm.Enabled:=false;
  Print;
  btnPrintForm.Enabled:=true;
end;


procedure TForm1.FormResize(Sender: TObject);
begin
  lblWidth.Caption:='Width='+IntToStr(ClientWidth);
  lblHeight.Caption:='Height='+IntToStr(ClientHeight);
end;

procedure TForm1.btnExitClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.chkLandscapeClick(Sender: TObject);
begin
  if chkLandscape.Checked then prtSelection.PrinterSettings.Orientation:=Landscape
                          else prtSelection.PrinterSettings.Orientation:=Portrait;
end;

end.
